<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('reference_counts')) {
            return;
        }

        if (!Schema::hasColumn('reference_counts', 'business_id') || !Schema::hasColumn('reference_counts', 'ref_type')) {
            return;
        }

        $indexExists = DB::table('information_schema.statistics')
            ->where('table_schema', DB::getDatabaseName())
            ->where('table_name', 'reference_counts')
            ->where('index_name', 'ref_counts_business_type_unique')
            ->exists();

        if ($indexExists) {
            return;
        }

        Schema::table('reference_counts', function (Blueprint $table) {
            $table->unique(['business_id', 'ref_type'], 'ref_counts_business_type_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (!Schema::hasTable('reference_counts')) {
            return;
        }

        $indexExists = DB::table('information_schema.statistics')
            ->where('table_schema', DB::getDatabaseName())
            ->where('table_name', 'reference_counts')
            ->where('index_name', 'ref_counts_business_type_unique')
            ->exists();

        if (! $indexExists) {
            return;
        }

        Schema::table('reference_counts', function (Blueprint $table) {
            $table->dropUnique('ref_counts_business_type_unique');
        });
    }
};
